﻿using VA.TMP.Integration.VIMT.Messages.VirtualMeetingRoom;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.OnDemand
{
    /// <summary>
    /// Create Response step.
    /// </summary>
    public class CreateResponseStep : FilterBase<VmrOnDemandCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VmrOnDemandCreateStateObject state)
        {
            if (state.UseFakeResponse)
            {
                state.VmrOnDemandCreateResponseMessage = new VmrOnDemandCreateResponseMessage
                {
                    ExceptionMessage = "*****THIS IS FAKE DATA. VMR NOT CREATED*****",
                    ExceptionOccured = false,
                    MeetingRoomName = state.MeetingRoomName,
                    PatientUrl = state.PatientUrl,
                    ProviderUrl = state.ProviderUrl,
                    PatientPin = state.PatientPin,
                    ProviderPin = state.ProviderPin,
                    AppointmentId = state.CorrelationId,
                    DialingAlias = string.Format("{0}{1}", state.VirtualMeetingRoom, state.VirtualMeetingRoomSuffix),
                    MiscData = string.Format("hostDialUrl={0};guestDialUrl={1};", state.ProviderUrl, state.PatientUrl),
                    SerializedInstance = state.SerializedVirtualMeetingRoom
                };
                Logger.Instance.Debug("Used Fake Response");
            }
            else
            {
                state.VmrOnDemandCreateResponseMessage = state.ExceptionOccured
                ? new VmrOnDemandCreateResponseMessage { ExceptionOccured = true, ExceptionMessage = state.ExceptionMessage, EcProcessingMs = state.EcProcessingTimeMs }
                : new VmrOnDemandCreateResponseMessage
                {
                    ExceptionMessage = string.Empty,
                    ExceptionOccured = false,
                    MeetingRoomName = state.MeetingRoomName,
                    PatientUrl = state.PatientUrl,
                    ProviderUrl = state.ProviderUrl,
                    PatientPin = state.PatientPin,
                    ProviderPin = state.ProviderPin,
                    AppointmentId = state.CorrelationId,
                    DialingAlias = state.DialingAlias,
                    MiscData = state.MiscDataForResponse,
                    SerializedInstance = state.SerializedVirtualMeetingRoom,
                    EcProcessingMs = state.EcProcessingTimeMs
                };
            }
        }
    }
}